/*
 * Blink.cpp
 *
 * Created: 27/08/2019 18:57:18
 * Author : HiboTronix
 */ 
#define F_CPU 8000000UL // 8MHz Internal Oscillator

#include <avr/io.h>
#include <util/delay.h>
#include <string.h>
#include "Delay_Timer.h"
#include "Serial.h"

int main(void) {
	Serial_Init();
	CCP = 0xD8; // CCP_IOREG_gc Set The Configuration Change Protection 
	            // Register To 0xD8 And Change CLKPSR Within 4 Clock Cycles 
	
	CLKPSR = 0; // Set Clock Prescaler To 1 For 8MHz Internal Clock
	DDRA = 0x20; // PA5 as output, Led Cathode Connected To Pin
	PORTA |= (1<<5); // PA5 High = Led Off
    while (1) {  // Equivilent To The Arduino Loop
		PORTA |= (1<<5); // PA5 High = Led Off
		Serial_PrintLn("Led Off");
		delay_ms(1000);
		PORTA &= ~(1<<5); //PA5 Low = Led On
		Serial_PrintLn("Led On");
		delay_ms(1000);
    }	
}