/*
 * Serial.h
 *
 * Created: 27/08/2019 18:57:18
 * Author : HiboTronix
 */ 

void Serial_Init() {
	UBRR = 0x33; // Set Baud To 9600
	UCSRA = (0<<U2X) | (0<<MPCM); // MCPM Off, Single Speed
	UCSRB = (1<<RXEN) | (1<<TXEN) | (0<<UCSZ2); // Enable Receiver And Transmitter
	UCSRC = (0<<UMSEL1) | (0<<UMSEL0) | (0<<UPM1) | (0<<UPM0) | (0<<USBS) | (1<<UCSZ1) | (1<<UCSZ0) | (0<<UCPOL); // Set Frame Format: 8N1
}

void Serial_Write(char data ) {
	/* Wait for empty transmit buffer */
	while (!(UCSRA & (1<<UDRE))) {}
	/* Put data into buffer, sends the data */
	UDR = data;
}

void Serial_Print(const char c[]) {
	for (uint8_t i = 0; i < strlen(c); i++) { // Loop Through Each Char
		Serial_Write(c[i]);
	}
}

void Serial_PrintLn(const char c[]) {
	for (uint8_t i = 0; i < strlen(c); i++) { // Loop Through Each Char
		Serial_Write(c[i]);
	}
	Serial_Write(13); // CR, Carriage Return
	Serial_Write(10); // LF, Line Feed	
}

unsigned char Serial_ReadByte( void ) {
	/* Wait For Data To Be Received */
	while (!(UCSRA & (1<<RXC))) {}
	/* Get And Return Received Data From Buffer */
	return UDR;
}

void Serial_Flush( void ) {
	unsigned char dummy;
	while (UCSRA & (1<<RXC)) {
		dummy = UDR;
	}
}